/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.bookmark;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.bookmark.Bookmark;
import de.willuhn.jameica.bookmark.Context;
import de.willuhn.jameica.bookmark.ContextSerializer;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.store.BeanContainer;
import de.willuhn.jameica.store.BeanStore;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class BookmarkService {
    public static final String QUEUE_CREATED = "jameica.bookmark.created";
    public static final String QUEUE_DELETED = "jameica.bookmark.deleted";
    @Resource
    private BeanStore store;
    @Resource
    private ContextSerializer serializer;
    private BeanContainer<Bookmark> beans = null;
    private Object mutex = new Object();

    public List<Bookmark> getBookmarks() throws ApplicationException {
        return this.getBeanContainer().getBeans();
    }

    public Bookmark create(String comment) throws ApplicationException {
        Bookmark b = new Bookmark();
        b.setComment(comment);
        b.setCreated(new Date());
        b.setTitle(GUI.getView().getTitle());
        AbstractView view = GUI.getCurrentView();
        b.setView(view.getClass().getName());
        b.setContext(this.serializer.serialize(view.getCurrentObject()));
        this.getBookmarks().add(b);
        this.store();
        Application.getMessagingFactory().getMessagingQueue(QUEUE_CREATED).sendMessage(new QueryMessage(b));
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Lesezeichen erstellt"), 0));
        return b;
    }

    public Bookmark find() throws ApplicationException {
        AbstractView view = GUI.getCurrentView();
        String viewClass = view.getClass().getName();
        for (Bookmark b : this.getBookmarks()) {
            Context context;
            if (!viewClass.equals(b.getView()) || !EqualsBuilder.reflectionEquals((Object)(context = this.serializer.serialize(view.getCurrentObject())), (Object)b.getContext())) continue;
            return b;
        }
        return null;
    }

    public List<Bookmark> search(String s) throws ApplicationException {
        ArrayList<Bookmark> result = new ArrayList<Bookmark>();
        String query = StringUtils.trimToNull((String)s);
        if (query == null) {
            return result;
        }
        query = query.toLowerCase();
        List<Bookmark> list = this.getBookmarks();
        for (Bookmark b : list) {
            String title = StringUtils.trimToEmpty((String)b.getTitle());
            String comment = StringUtils.trimToEmpty((String)b.getComment());
            if (!comment.toLowerCase().contains(query) && !title.toLowerCase().contains(query)) continue;
            result.add(b);
        }
        return result;
    }

    public void delete(Bookmark bookmark) throws ApplicationException {
        this.getBookmarks().remove(bookmark);
        this.store();
        Application.getMessagingFactory().getMessagingQueue(QUEUE_DELETED).sendMessage(new QueryMessage(bookmark));
        Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Lesezeichen gel\u00f6scht"), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanContainer<Bookmark> getBeanContainer() throws ApplicationException {
        if (this.beans == null) {
            Object object = this.mutex;
            synchronized (object) {
                this.beans = this.store.load(Bookmark.class, true);
            }
        }
        return this.beans;
    }

    public void store() throws ApplicationException {
        this.store.store(this.getBeanContainer());
    }
}

